<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.1
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;

$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = $product->get_image_id();
$image         = wp_get_attachment_image($post_thumbnail_id, 'shop_single', true,array( "class" => "attachment-shop_single size-shop_single wp-post-image" ));
$wrapper_classes   = apply_filters(
	'woocommerce_single_product_image_gallery_classes',
	array(
		'woocommerce-product-gallery',
		'woocommerce-product-gallery--' . ( $product->get_image_id() ? 'with-images' : 'without-images' ),
		'woocommerce-product-gallery--columns-' . absint( $columns ),
		'images',
	)
);
?>
<div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
<?php if (has_post_thumbnail()) { 

$attachment_ids = $product->get_gallery_image_ids();
$lightbox_src = wc_get_product_attachment_props($post_thumbnail_id);
?>
								<div class="blog-media fl-wrap">
                                        <div class="single-slider-wrap">
                                            <div class="single-slider fl-wrap">
                                                <div class="swiper-container">
                                                    <div class="swiper-wrapper lightgallery">
                                                        <div class="swiper-slide hov_zoom"><img src="<?php echo esc_url($lightbox_src['url']);?>" alt="<?php echo esc_url($lightbox_src['title']);?>"><a href="<?php echo esc_url($lightbox_src['url']);?>" class="box-media-zoom   popup-image"><i class="fal fa-search"></i></a></div>
														<?php 
									
														if ($attachment_ids) {
														foreach ($attachment_ids as $attachment_id) {
															 $thumbnail_image     = wp_get_attachment_image($attachment_id, 'shop_single');
															 $lightbox_src = wc_get_product_attachment_props($attachment_id);
															// fw_print($thumbnail_src);
															  echo '<div class="swiper-slide hov_zoom"><img src="'.$lightbox_src['url'].'" alt="'.$lightbox_src['title'].'"><a href="'.$lightbox_src['url'].'" class="box-media-zoom   popup-image"><i class="fal fa-search"></i></a></div>';

														}
													}
														?>
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="ss-slider-pagination_wrap">
                                                <div class="ss-slider-pagination"></div>
                                            </div>
                                            <div class="ss-slider-cont ss-slider-cont-prev color-bg"><i class="fal fa-long-arrow-left"></i></div>
                                            <div class="ss-slider-cont ss-slider-cont-next color-bg"><i class="fal fa-long-arrow-right"></i></div>
                                        </div>
                                    </div>
									
	<?php } else {?>
	<figure class="woocommerce-product-gallery__wrapper">
		<?php
		if ( $product->get_image_id() ) {
			$html = wc_get_gallery_image_html( $post_thumbnail_id, true );
		} else {
			$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
			$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) );
			$html .= '</div>';
		}

		echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id ); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped

		do_action( 'woocommerce_product_thumbnails' );
		?>
	</figure>
	<?php } ;?>
</div>
