<?php

class Kotlis_Twitter_Widget extends WP_Widget {
    var $settings = array( 'title', 'buttontxt', 'buttonurl', 'username', 'twitts_count');

    function __construct() {
        $widget_ops = array('description' => 'Use this widget to add Twitter feed.' );
        parent::__construct(false, esc_html__('Kotlis Twitter Widget', 'kotlis'),$widget_ops);
}

function widget($args, $instance) {
        $settings = $this->kotlis_get_settings();
        extract( $args, EXTR_SKIP );
        $instance = wp_parse_args( $instance, $settings );
        extract( $instance, EXTR_SKIP );

      
         echo $before_widget; 
        
        if ( $title != '' )
            echo $before_title . apply_filters( 'widget_title', $title, $instance, $this->id_base ) . $after_title;
        
		echo'<div class="sb-widget fl-wrap">';
		   echo'<div id="footer-twiit" data-api="'.get_template_directory_uri().'/includes/twitter-api/api/tweet.php" data-twitts-user="'.$username.'" ';
		   if ( $twitts_count != '' ) {
		   echo 'data-twitts-count="'.$twitts_count.'"';
		   }
		   else {
		   echo 'data-twitts-count="2"';
		   }
		   echo'></div>';		
			if ( $buttonurl != '' ) {
			echo '<a href="'.$buttonurl.'"  target="_blank" class="twitt_btn fl-wrap">';
				if ( $buttontxt != '' ) {
				 echo $buttontxt;
				}
				else {
				echo 'Follow Us';
				}
			echo '</a>';
			}
		
       echo '</div>';      
       echo $after_widget;      
    }
	
function update( $new_instance, $old_instance ) {
        foreach ( array( 'title', 'instagram_token' ) as $setting )
            $new_instance[$setting] = strip_tags( $new_instance[$setting] );
        // Users without unfiltered_html cannot update this arbitrary HTML field
        if ( !current_user_can( 'unfiltered_html' ) )
            $new_instance['address'] = $old_instance['address'];
        return $new_instance;
    }


    function kotlis_get_settings() {
        // Set the default to a blank string
        $settings = array_fill_keys( $this->settings, '' );
        // Now set the more specific defaults
        return $settings;
    }

    function form($instance) {
        $instance = wp_parse_args( $instance, $this->kotlis_get_settings() );
        extract( $instance, EXTR_SKIP );
?>

    <p>
        <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title:','kotlis'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr( $title ); ?>" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('username'); ?>"><?php esc_html_e('Twitter User Name:','kotlis'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('username'); ?>" value="<?php echo esc_attr( $username ); ?>" class="widefat" id="<?php echo $this->get_field_id('username'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('twitts_count'); ?>"><?php esc_html_e('Twitts Count:','kotlis'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('twitts_count'); ?>" value="<?php echo esc_attr( $twitts_count ); ?>" class="widefat" id="<?php echo $this->get_field_id('twitts_count'); ?>" />
    </p>
	
	
	<p>
        <label for="<?php echo $this->get_field_id('buttontxt'); ?>"><?php esc_html_e('Button Text:','kotlis'); ?><br><?php esc_html_e('Ex: Follow Us ','kotlis'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('buttontxt'); ?>" value="<?php echo esc_attr( $buttontxt ); ?>" class="widefat" id="<?php echo $this->get_field_id('buttontxt'); ?>" />
    </p>
	
	<p>
        <label for="<?php echo $this->get_field_id('buttonurl'); ?>"><?php esc_html_e('Button URL:','kotlis'); ?></label>
        <input type="text" name="<?php echo $this->get_field_name('buttonurl'); ?>" value="<?php echo esc_attr( $buttonurl ); ?>" class="widefat" id="<?php echo $this->get_field_id('buttonurl'); ?>" />
    </p>


    <?php 

    }
}

register_widget('Kotlis_Twitter_Widget');	
