<?php

/* Template Name: Contact-Us */



?><!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="keywords" content="">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
	<meta name="robots" content="index, follow">
    <link rel="shortcut icon" type="image/svg" href="<?php if (get_option('site_icon')){echo get_site_icon_url();}else{ echo get_template_directory_uri().'/favicon.svg';}?>">
    
	
    <title>Contact Us</title>

	<?php wp_head(); ?><link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
<a href="https://api.whatsapp.com/send?phone=212610387067&text=Bonjour" class="float" target="_blank">
<i class="fa fa-whatsapp my-float"></i>
</a>

    
<!-- Analytics -->
 
<!-- Analytics END -->
    
</head>
<body class="  <?php echo implode(" ",get_body_class()); ?>">

<!-- Preloader -->
<div id="page-loading-blocs-notifaction" class="page-preloader"></div>
<!-- Preloader END -->


<!-- Main container -->
<div class="page-container">
    
<?php get_header(); ?>

<!-- contact -->
<div class="bloc b-parallax bloc-bg-texture texture-darken-strong d-bloc" id="contact">
	<div class="parallax bg-scissor-rack bgc-1165">
	</div>
	<div class="container bloc-xl-lg bloc-md bloc-md-sm bloc-lg-md">
		<div class="row">
			<div class="col-lg-6 offset-lg-3 text-lg-center mb-5 text-center">
				<h3 class="mb-4 section-heading tc-6728">
					CONTACT US
				</h3>
				<div class="divider-h primary-divider center-divider">
				</div>
				<p class="section-p tc-3648">
					Feel free to get in contact with us using the form below, and we will respond back to you ASAP. If you require an instant response, please give us a call.
				</p>
			</div>
			<div class="text-lg-left col-md-6 mb-sm-4 mb-4 mb-md-0 col-lg-6 offset-lg-1">
				<form template-path="<?php echo get_template_directory_uri(); ?>/" id="contact_form" data-form-type="blocs-form" novalidate="" data-success-msg="Your message has been sent." data-fail-msg="Sorry it seems that our mail server is not responding, Sorry for the inconvenience!">
					<div class="form-group">
						<input id="name" class="form-control custom-field" required="" placeholder="Name">
					</div>
					<div class="form-group">
						<input id="email" class="form-control custom-field" type="email" data-error-validation-msg="Not a valid email address" required="" placeholder="Email">
					</div>
					<div class="form-group">
						<textarea id="message" class="form-control custom-field" rows="6" cols="50" required="" placeholder="Message"></textarea>
					</div> 
					<button class="bloc-button btn btn-lg btn-block btn-sq btn-d primary-btn" type="submit">
						Book Appointment
					</button>
				</form>
			</div>
			<div class="text-lg-center col-lg-4 col-md-6 text-md-center text-sm-center d-flex offset-md-0 offset-sm-0 col-sm-12 offset-lg-0">
				<div class="box text-sm-center text-center">
					<h3 class="mg-md">
						<strong>Opening Hours</strong>
					</h3>
					<ul class="list-unstyled">
						<li>
							<p class="tc-3648">
								<strong>Monday - Friday 9am-5pm</strong>
							</p>
						</li>
						<li>
							<p class="tc-3648">
								<strong>Saturday 9am - 3pm</strong>
							</p>
						</li>
						<li>
							<p class="tc-3648">
								<strong>Sunday - Closed</strong>
							</p>
						</li>
					</ul>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- contact END -->

<!-- ScrollToTop Button -->
<button aria-label="Scroll to top button" class="bloc-button btn btn-d scrollToTop" onclick="scrollToTarget('1',this)"><svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 32 32"><path class="scroll-to-top-btn-icon" d="M30,22.656l-14-13-14,13"/></svg></button>
<!-- ScrollToTop Button END-->


<?php get_footer(); ?>

</div>
<!-- Main container END -->
    
<?php wp_footer(); ?>

<!-- Additional JS -->
<script type='text/javascript' src="<?php echo get_template_directory_uri(); ?>/js/jqBootstrapValidation.js"></script>
<script type='text/javascript' src="<?php echo get_template_directory_uri(); ?>/js/formHandler.js?501"></script>
<script type='text/javascript' src="<?php echo get_template_directory_uri(); ?>/js/lazysizes.min.js" defer></script>

<script src="<?php echo get_template_directory_uri(); ?>/js/universal-parallax.min.js?7184"></script><!-- Additional JS END -->


</body>
</html>
